using System; 
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;
using System.IO;

namespace Fetch_BLOB_from_DB
{
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : System.Windows.Forms.Form
    {

        private SqlConnection cn; 
        private SqlCommand cmdCover;
        private SqlCommand cmdFileName; 

        internal System.Windows.Forms.ComboBox cmbISBNList;
        internal System.Windows.Forms.Button btnShow;
        internal System.Windows.Forms.PictureBox pbCover;
        private System.Windows.Forms.Button btnShowLoadFile;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Form1()
        {
            try
            {
                //
                // Required for Windows Form Designer support
                //
                InitializeComponent();

                //
                // TODO: Add any constructor code after InitializeComponent call
                //

                cn = new SqlConnection("data source=.;database=biblio;trusted_connection=yes");
                cmdCover= new SqlCommand("Select ID, Cover from Covers where ISBN = @ISBNWanted", cn);
                cmdCover.Parameters.Add("@ISBNWanted", SqlDbType.VarChar, 20);
                cmdCover.CommandType = CommandType.Text;


                cmdFileName = new SqlCommand("Select ID, FileName from Covers where ISBN = @ISBNWanted", cn);
                cmdFileName.Parameters.Add("@ISBNWanted", SqlDbType.VarChar, 20);
                cmdFileName.CommandType = CommandType.Text;

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if( disposing )
            {
                if (components != null) 
                {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

		#region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            this.cmbISBNList = new System.Windows.Forms.ComboBox();
            this.btnShow = new System.Windows.Forms.Button();
            this.pbCover = new System.Windows.Forms.PictureBox();
            this.btnShowLoadFile = new System.Windows.Forms.Button();
            this.SuspendLayout();
            // 
            // cmbISBNList
            // 
            this.cmbISBNList.Location = new System.Drawing.Point(32, 344);
            this.cmbISBNList.Name = "cmbISBNList";
            this.cmbISBNList.Size = new System.Drawing.Size(176, 21);
            this.cmbISBNList.TabIndex = 7;
            // 
            // btnShow
            // 
            this.btnShow.Location = new System.Drawing.Point(248, 312);
            this.btnShow.Name = "btnShow";
            this.btnShow.Size = new System.Drawing.Size(184, 32);
            this.btnShow.TabIndex = 6;
            this.btnShow.Text = "Show Book Cover using GetByte";
            this.btnShow.Click += new System.EventHandler(this.btnShow_Click);
            // 
            // pbCover
            // 
            this.pbCover.Dock = System.Windows.Forms.DockStyle.Top;
            this.pbCover.Name = "pbCover";
            this.pbCover.Size = new System.Drawing.Size(536, 304);
            this.pbCover.TabIndex = 3;
            this.pbCover.TabStop = false;
            // 
            // btnShowLoadFile
            // 
            this.btnShowLoadFile.Location = new System.Drawing.Point(248, 352);
            this.btnShowLoadFile.Name = "btnShowLoadFile";
            this.btnShowLoadFile.Size = new System.Drawing.Size(184, 23);
            this.btnShowLoadFile.TabIndex = 8;
            this.btnShowLoadFile.Text = "Show Book Cover using LoadFile";
            this.btnShowLoadFile.Click += new System.EventHandler(this.btnShowLoadFile_Click);
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(536, 389);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.btnShowLoadFile,
                                                                          this.cmbISBNList,
                                                                          this.btnShow,
                                                                          this.pbCover});
            this.Name = "Form1";
            this.Text = "Form1";
            this.Load += new System.EventHandler(this.Form1_Load);
            this.ResumeLayout(false);

        }
		#endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main() 
        {
            Application.Run(new Form1());
        }

        private void Form1_Load(object sender, System.EventArgs e)
        {
            try
            {

                SqlDataReader dr;
                SqlCommand  cmdList =new SqlCommand("Select ISBN from Titles where CoverFileName IS NOT NULL", cn);
                cn.Open();
                dr = cmdList.ExecuteReader(CommandBehavior.CloseConnection);
                while (dr.Read())
                {
                    cmbISBNList.Items.Add(dr.GetValue(0));
                }
                cmbISBNList.SelectedIndex = 0;
                dr.Close();
            }
            catch( Exception ex)
            {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
        }
        private void btnShow_Click(object sender, System.EventArgs e)
        {
            try
            {   
                int bufferSize = 100;         // The size of the BLOB buffer.
                byte[] outbyte =
                    new byte [bufferSize]; // The BLOB byte[] buffer to be filled by GetBytes.
                long retval;                  // The bytes returned from GetBytes.
                long startIndex = 0;          // The starting position in the BLOB output.
                int dcID;



                // Open the connection (because a DataReader won't do it automatically)
                cn.Open();

                // Set the parameters of the SelectCommand for the cover we want
                cmdCover.Parameters["@ISBNWanted"].Value = cmbISBNList.Text;

                // Instantiate a DataReader for the cover: Setting Sequential Access and also the CloseConnection behaviour
                //
                // SequentialAccess -Provides a way for the DataReader to handle rows that contain columns with
                // large binary values. Rather than loading the entire row, SequentialAccess enables the DataReader
                // to load data as a stream. You can then use the GetBytes or GetChars method to specify a byte location
                // to start the read operation, and a limited buffer size for the data being returned. 
                // When you specify SequentialAccess, you are not required to read from the columns in the order they are
                // returned. However, once you have read past a location in the returned stream of data, data at or before
                // that location can no longer be read from the DataReader

                SqlDataReader drCover = cmdCover.ExecuteReader(CommandBehavior.SequentialAccess | CommandBehavior.CloseConnection);
                if (drCover.Read())
                {
                    // Get the  ID which must be returned before getting the Cover Image.
                    dcID = drCover.GetInt32(0);


                    // Instantiate a MemoryStream to hold the output.
                    MemoryStream ms = new MemoryStream();

                    // Create the BinaryWrite to populate the MemoryStream
                    BinaryWriter bw = new BinaryWriter(ms);  


                
                
                    // Reset the starting byte for a new BLOB.
                    startIndex = 0;

                    // Read bytes into outbyte() and retain the number of bytes returned.
                    retval = drCover.GetBytes(1, startIndex, outbyte, 0, bufferSize);

                    // Continue reading and writing while there are bytes beyond the size of the buffer.
                    while (retval == bufferSize)
                    {
                        bw.Write(outbyte);
                        bw.Flush();

                        // Reposition the start index to the end of the last buffer and fill the buffer.
                        startIndex = startIndex + bufferSize;
                        retval = drCover.GetBytes(1, startIndex, outbyte, 0, bufferSize);
                    }

                    Console.WriteLine("MemoryStream length:" + ms.Length);

                    // Write the remaining buffer.
                    bw.Write(outbyte);
                    bw.Flush();

                    
                    // Load the Image from the MemoryStream
                    pbCover.Image = Image.FromStream(ms);

                    // Close the MemoryStream and then the BinaryWriter
                    ms.Close();
                    bw.Close();
                    
                    // Close the Cover DataReader 
                    drCover.Close();
                }
                else
                {
                    MessageBox.Show("No cover on file for this ISBN");
                    drCover.Close();
                }
               
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
            finally // Force Closed the reader and the connection (should be closed by drCover.Close())
            {
                cn.Close();
            }

        }

        private void btnShowLoadFile_Click(object sender, System.EventArgs e)
        {
            try
            {
                cn.Open();
                cmdFileName.Parameters["@ISBNWanted"].Value = cmbISBNList.Text;
                SqlDataReader drCover = cmdFileName.ExecuteReader(CommandBehavior.SingleRow);
                string strFileName;

                if (drCover.Read())
                {
                    strFileName = drCover.GetString(1);
                    Console.WriteLine("Filename:" + strFileName);
                    pbCover.Image = Image.FromFile(strFileName);
                }
                else
                {
                    MessageBox.Show("No cover on file for this ISBN");
                    drCover.Close();
                }
            
                drCover.Close();
            }
            catch (System.IO.FileNotFoundException fnf)
            {
                MessageBox.Show("The File: \"" + fnf.Message + "\" not found. \n\n\n - you may need to update the database \n    to reflect the locatation to which you installed the CD\n ... or \n copy the Cover Pictures folder to c:\\" ,"File Not Found Problem");
                Debug.WriteLine(fnf.ToString());
            }
            catch (Exception ex)
            {
                
                MessageBox.Show(ex.ToString());
                Debug.WriteLine(ex.ToString());
            }
            finally
            {
                cn.Close();
            }
        }
   
    }
}

